var ContactList = new Class({
	owner: null,
  list: null,
  el: null,
  last_search_value: null,
	search_input_checker_timer: null,
	
	initialize: function(o){
		this.owner = o;
		this.list = new Hash();
		
    this.owner.loadCSS('contact_list');
    this.owner.loadCSS('contact_list_item');    
		
		var tpl = new Template("contact_list");
    this.el = new Element('div').adopt(tpl.xml).getFirst();
    this.load(this.owner.user.contacts);	
				
    var t = this;
				
	  // if contact list is updated - redraw it
		this.owner.user.addEvent('ContactListUpdate', function(){
			var new_list = this.owner.user.contacts;
			new_list.each(function(val, key){
				val.__open = t.list.has(key) && t.list.get(key).open;
				new_list.set(key, val);
			});
      t.load(this.owner.user.contacts);
			t.draw();
    });
		
		// setup new contact search
		var new_contact_text = 'Zadajte e-mail/nick a stlačte enter';		
		this.el.getElement('.new input').addEvents({
			'focus': function(){
			  if(this.value == new_contact_text){
					this.value = '';
          this.removeClass('def');
				} 
			}, 
			'blur': function(){
				if(this.value == ''){
					 this.value = new_contact_text;
           this.addClass('def');
				}
			},
			'keydown': function(ev){
				var e = new Event(ev); 
				$clear(this.search_input_checker_timer);
				if(e.key == 'enter'){
					t.searchContact(this.value, false);
				}
			}
		}).fireEvent('blur');
		
		// setup automatically refreshing of search
		var search_input_checker = function(defvalue){
			// not text - clear results
			if (this.value == '') {
				t.last_search_value = '';
		  	t.el.getElement('.searches').empty();
				return;
		  }
			if((this.value == defvalue) || (this.value == t.last_search_value)) return;
      t.searchContact(this.value, true);
		}
		this.search_input_checker_timer = search_input_checker.periodical(1000, this.el.getElement('.new input'), new_contact_text);
		
	},
	
	searchContact: function(str, automatic){
    var sl_el = this.el.getElement('.searches');
			
		// launched automatically after some period of time
		if(automatic){
      if(str.length == 0) return;
      sl_el.empty();
		
		// called manualy by hitting enter	
		} else {
      sl_el.empty();
			
			if(str.length == 0){
	      alert('Zadajte časť e-mailu alebo prezývky a stlačte enter.');
	      return;
	    }
		}
		
    this.last_search_value = str;
		
    var t = this;
    this.owner.server.request({'action': 'search_contacts', 'args': {'search': str}}, function(response){
      // show searches list
      if($defined(response) && $defined(response.contacts)){     
				// read template for later use
		    var tpl = new Template("search_list_item");
		    var contact_el_tpl = new Element('div').adopt(tpl.xml).getFirst();
		
		    // parse found contacts
        $each(response.contacts, function(item, key){
					var contact_el = contact_el_tpl.clone();
					
					// fill info
			    $each(item, function(value, key){
			      var el = contact_el.getElement('.'+key);      
			      if($defined(el)) el.set('text', value);
			    });
					
					// assign click event
					contact_el.getElement('.header').addEvent('click', function(){
						// add user and clear search if insert was successful 
            t.owner.user.addContact(item.id, function(successful){
							if(successful){
	              t.el.getElement('.new input').value = '';
	              t.el.getElement('.new input').fireEvent('blur');
								sl_el.empty();
							}
            }); 
			    });

          sl_el.adopt(contact_el);
        });
      }
    });
	},
	
  add: function(key, info){
		this.list.set(key, new ContactListItem(this.owner, info, info.__open));
		return this;
	},
	
	empty: function(){
		this.list.empty();
	},
	
	load: function(contacts){
		this.empty();
		contacts.each(function(info, key){
			this.add(key, info);
		}, this);
		return this;
	},
	
	draw: function(){
		var listel = this.el.getElement('.items');
		listel.empty();
		this.list.each(function (value, key){
			listel.adopt(value.getEl());
		}, this);
		return this;
	},
	
	getEl: function(){
		return this.draw().el;
	}
});

ContactList.implement(new Options);